rule Win32_Ransomware_Encoded01 : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "ENCODED01"
        description         = "Yara rule that detects Encoded01 ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Encoded01"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            55 8B EC 51 B9 ?? ?? ?? ?? 6A ?? 6A ?? 49 75 ?? 51 87 4D ?? 53 56 57 89 4D ?? 89 55
            ?? 89 45 ?? 8B 45 ?? E8 ?? ?? ?? ?? 8D 45 ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ??
            64 FF 30 64 89 20 8B 45 ?? E8 ?? ?? ?? ?? 83 F8 ?? 0F 8C ?? ?? ?? ?? 8D 85 ?? ?? ??
            ?? 8B 15 ?? ?? ?? ?? 8B 12 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 55 ?? E8 ?? ?? ?? ??
            8B 45 ?? E8 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 0F 8E ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ??
            ?? 8B 55 ?? 66 83 7C 42 ?? ?? 75 ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B D0 4A 8D 45 ?? E8 ??
            ?? ?? ?? 8B 7D ?? 4F 85 FF 0F 8C ?? ?? ?? ?? 47 8D 85 ?? ?? ?? ?? 50 FF 75 ?? 68 ??
            ?? ?? ?? 8B 45 ?? 8B 55 ?? FF 34 90 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ??
            8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B D8 83 FB ?? 0F 84 ?? ?? ?? ??
            33 F6 46 81 FE ?? ?? ?? ?? 0F 87 ?? ?? ?? ?? 83 FB ?? 0F 84 ?? ?? ?? ?? 8D 45 ?? 8D
            95 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ??
            0F 84 ?? ?? ?? ?? 8B 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? F6 85 ??
            ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? F6 85 ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? FF 75 ?? 68 ??
            ?? ?? ?? FF 75 ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ??
            8D 95 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8D 45 ?? E8 ?? ?? ?? ?? 8B 55 ??
            8B 45 ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8A 55 ?? 8B 45 ?? E8 ?? ?? ?? ?? 84
        }

        $find_files_p2 = {
            C0 0F 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 12 E8 ?? ?? ?? ?? 8B 95
            ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 84 C0 0F 85 ?? ?? ?? ?? 8A 55 ?? 8B 45 ?? E8 ??
            ?? ?? ?? 84 C0 0F 85 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 84 C0 0F 85 ?? ?? ?? ?? A1
            ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 89 45 ?? 89 55 ?? 6A ?? 68 ??
            ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 50 ?? 8B 00 E8 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 3B 55 ?? 75 ?? 3B 45 ?? 0F 86 ?? ?? ?? ?? EB ?? 0F 8E ?? ?? ?? ?? 83 7D ?? ??
            75 ?? 83 7D ?? ?? 0F 86 ?? ?? ?? ?? EB ?? 0F 8E ?? ?? ?? ?? 8B 45 ?? 83 38 ?? 73 ??
            8B 45 ?? E8 ?? ?? ?? ?? 40 03 C0 50 E8 ?? ?? ?? ?? 59 89 45 ?? 83 7D ?? ?? 0F 84 ??
            ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 40 03 C0 50 8B 45 ?? E8 ??
            ?? ?? ?? 8B D0 8B 45 ?? 59 E8 ?? ?? ?? ?? 8B 45 ?? 50 6A ?? 8D 45 ?? 50 B9 ?? ?? ??
            ?? 33 D2 33 C0 E8 ?? ?? ?? ?? 8B D0 8B 45 ?? E8 ?? ?? ?? ?? EB ?? 8B 45 ?? E8 ?? ??
            ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 40 03 C0 50 E8 ?? ?? ?? ?? 59 89 45 ?? 83 7D ?? ?? 74
            ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 40 03 C0 50 8B 45 ?? E8 ?? ?? ??
            ?? 8B D0 8B 45 ?? 59 E8 ?? ?? ?? ?? 8B 45 ?? 50 6A ?? 8D 45 ?? 50 B9 ?? ?? ?? ?? 33
            D2 33 C0 E8 ?? ?? ?? ?? 8B D0 8B 45 ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 E8 ?? ?? ??
            ?? EB ?? 8B 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 74 ?? 8B 45 ?? BA ?? ?? ?? ?? E8 ??
            ?? ?? ?? 74 ?? F6 85 ?? ?? ?? ?? ?? 74 ?? 8A 45 ?? 50 8A 45 ?? 50 FF 75 ?? 68 ?? ??
            ?? ?? FF 75 ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B
            55 ?? 8B 45 ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 53 E8 ?? ?? ?? ?? 83 F8 ?? 1B C0
            40 84 C0 0F 85 ?? ?? ?? ?? 83 FB ?? 74 ?? 53 E8 ?? ?? ?? ?? 4F
        }

        $enum_resources = {
            55 8B EC 83 C4 ?? 53 56 57 8B F9 89 55 ?? 8B F0 8B 5D ?? C6 45 ?? ?? 33 C0 89 03 33
            C0 89 07 8D 45 ?? 50 8B 45 ?? 50 6A ?? 56 6A ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ??
            ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 89 03 83 3B ?? 74 ?? 83 3B ?? 74 ??
            C7 07 ?? ?? ?? ?? 8B 03 33 C9 8B 55 ?? E8 ?? ?? ?? ?? 8D 45 ?? 50 8B 03 50 57 8B 45
            ?? 50 E8 ?? ?? ?? ?? 8B F0 81 FE ?? ?? ?? ?? 75 ?? 8B C3 8B 55 ?? E8 ?? ?? ?? ?? EB
            ?? BE ?? ?? ?? ?? EB ?? 81 FE ?? ?? ?? ?? 74 ?? 85 F6 0F 94 45 ?? 80 7D ?? ?? 75 ??
            8B 03 E8 ?? ?? ?? ?? 33 C0 89 03 33 C0 89 07 8B 45 ?? 50 E8 ?? ?? ?? ?? 8A 45 ?? 5F
            5E 5B 8B E5 5D C2
        }

        $remote_connection_p1 = {
            BB ?? ?? ?? ?? 83 FB ?? 75 ?? 33 C0 89 45 ?? 83 FB ?? 75 ?? C7 45 ?? ?? ?? ?? ?? 8B
            C6 E8 ?? ?? ?? ?? 8B C6 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 33 C0 89 45 ?? 8D 45 ??
            50 8B 55 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B 45 ?? E8 ?? ?? ?? ?? 5A 2B C2 83 C0
            ?? 50 8B 55 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 83 C2 ?? 8B 45 ?? 59 E8 ?? ?? ??
            ?? 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 66 BA ??
            ?? E8 ?? ?? ?? ?? 50 8B 45 ?? E8 ?? ?? ?? ?? 5A 2B C2 50 8D 85 ?? ?? ?? ?? 8B 55 ??
            E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 66 BA ?? ?? E8 ?? ?? ?? ?? 8B D0 42 8B 45 ?? 59 E8
            ?? ?? ?? ?? 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ??
            66 BA ?? ?? E8 ?? ?? ?? ?? 8B C8 49 BA ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 85 FF 0F
            85 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 48 0F 8E ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8B 45
            ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? 6A ?? 6A
            ?? 6A ?? 6A ?? 6A ?? 6A ?? 8B 45 ?? E8 ?? ?? ?? ?? 50 8B 45 ?? 50 E8 ?? ?? ?? ?? 89
            45 ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 68 ?? ?? ?? ??
            8B 45 ?? E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 89 45 ?? 83 7D
            ?? ?? 0F 84 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 50 8B 45 ?? E8 ?? ?? ?? ?? 50 6A
        }

        $remote_connection_p2 = {
            68 ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 45 ?? 50 68 ??
            ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8B 45 ?? 50 E8 ?? ?? ?? ?? 85 C0 74 ?? 83 7D ?? ?? 74
            ?? 8B 06 E8 ?? ?? ?? ?? 99 52 50 8B 45 ?? 03 C7 33 D2 3B 54 24 ?? 75 ?? 3B 04 24 5A
            58 76 ?? EB ?? 5A 58 7E ?? 8B 06 E8 ?? ?? ?? ?? 8B D0 81 C2 ?? ?? ?? ?? 8B C6 E8 ??
            ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 03 C7 8D 95 ?? ?? ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 03 7D
            ?? 81 FF ?? ?? ?? ?? 77 ?? 83 7D ?? ?? 0F 85 ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ??
            8B 45 ?? 50 E8 ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 6A ?? 6A ?? 6A
            ?? 8B 45 ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ??
            6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 8B 45 ?? E8 ?? ?? ?? ?? 50 8B 45 ?? 50 E8 ?? ??
            ?? ?? 89 45 ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 68 ??
            ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8B 45 ?? 50 E8 ?? ?? ?? ?? 89 45
            ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 8B 45 ?? 50 E8 ??
            ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 45 ?? 50 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8B
            45 ?? 50 E8 ?? ?? ?? ?? 85 C0 74 ?? 83 7D ?? ?? 74 ?? 8B 06 E8 ?? ?? ?? ?? 99 52 50
            8B 45 ?? 03 C7 33 D2 3B 54 24 ?? 75 ?? 3B 04 24 5A 58 76 ?? EB ?? 5A 58 7E ?? 8B 06
            E8 ?? ?? ?? ?? 8B D0 81 C2 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 03
            C7 8D 95 ?? ?? ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 03 7D ?? 81 FF ?? ?? ?? ?? 77 ?? 83 7D
            ?? ?? 0F 85 ?? ?? ?? ?? 8B 45 ?? 50 E8
        }

        $encrypt_files = {
            55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 ??
            E8 ?? ?? ?? ?? FF 75 ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 ?? E8 ?? ?? ?? ?? FF 75
            ?? 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 ?? E8 ?? ?? ?? ?? FF 75 ?? 68
            ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 ?? E8 ?? ?? ?? ?? FF 75 ?? 68 ?? ??
            ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 ?? E8 ?? ?? ?? ?? FF 75 ?? 68 ?? ?? ?? ??
            8D 55 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 ?? 68 ?? ?? ?? ?? 8D 55 ?? B8 ?? ?? ??
            ?? E8 ?? ?? ?? ?? FF 75 ?? 68 ?? ?? ?? ?? 8D 55 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF
            75 ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 ?? E8 ?? ?? ?? ?? FF 75 ?? 68 ?? ?? ?? ??
            E8 ?? ?? ?? ?? 8D 55 ?? E8 ?? ?? ?? ?? FF 75 ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55
            ?? E8 ?? ?? ?? ?? FF 75 ?? 68 ?? ?? ?? ?? 8D 45 ?? E8 ?? ?? ?? ?? FF 75 ?? 68 ?? ??
            ?? ?? 8D 45 ?? E8 ?? ?? ?? ?? FF 75 ?? 8D 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D
            ?? ?? 74
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $enum_resources
        ) and
        (
            all of ($find_files_p*)
        ) and
        (
            $encrypt_files
        ) and
        (
            all of ($remote_connection_p*)
        )
}